<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\TipoPago;

class TipoPagoController extends Controller
{
    public function index()
    {
        $tipos_pago = TipoPago::all();
        return view('tipo-pago.index', compact('tipos_pago'));
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        // Validación de los datos
        $request->validate([
            'nombre' => 'required|unique:tipo_pago,nombre',
            'banco_o_entidad' => 'required',
            'numero_cuenta' => 'required',
            'cci' => 'required',
            'nombre_titular' => 'required',
        ]);

        // Crear el nuevo tipo de pago
        TipoPago::create($request->all());

        // Retornar una respuesta JSON
        return response()->json([
            'success' => 'Tipo de pago registrado correctamente.'
        ]);
    }


    public function show($id)
    {
        return TipoPago::findOrFail($id);
    }

    public function edit($id)
    {
        $tipoPago = TipoPago::findOrFail($id);
        return view('tipo_pago.edit', compact('tipoPago'));
    }

    public function update(Request $request, $id)
    {
        $tipoPago = TipoPago::findOrFail($id);

        $request->validate([
            'nombre' => 'required|unique:tipo_pago,nombre,' . $id . ',id_tipo_pago',
            'banco_o_entidad' => 'required',
            'numero_cuenta' => 'required',
            'cci' => 'required',
            'nombre_titular' => 'required',
        ]);

        $tipoPago->update($request->all());

        return response()->json(['success' => 'Tipo de pago actualizado correctamente.']);
    }

    public function destroy($id)
    {
        $tipoPago = TipoPago::findOrFail($id);
        $tipoPago->delete();

        return response()->json(['success' => 'Tipo de pago eliminado correctamente.']);
    }

    public function cambiarEstado(Request $request)
    {
        $tipoPago = TipoPago::findOrFail($request->id);
        $tipoPago->activo = !$tipoPago->activo;
        $tipoPago->save();

        return response()->json(['success' => 'Estado actualizado correctamente.']);
    }
}
